function [rms_errors, cdx_new] = wrapper_tranche_mispricing_xi(xi, i, CDX, discounts_IMM, start_date_num, end_date_num, N, maturities_cds, ...
                                                               maturities_tranches, RMSE_method, LGD_method, how_port_loss, method5, method2, CDX2)
% --------------------------------------------------------------------------------------------------
% Wrapper function for 'wrapper_tranche_mispricing_xi', where only the i-th value of x0 is allowed
% to vary.
% --------------------------------------------------------------------------------------------------
% xi                            ... new value/time-series for i-th parameter
% i                             ... which parameter to vary (of [k, theta, sigma, L, mu, rho1])
% CDX                           ... credit index structure (see 'all_steps_in_a_row.m')
% discounts_IMM                 ... structure with discount curves matching IMM dates
% start_date_num                ... datenum of start date
% end_date_num                  ... datenum of end date
% N                             ... number of points for numerical integration of Fourier transform
% maturities_cds                ... which maturities to fit for CDS prices, default: all
% maturities_tranches           ... which maturities to fit for tranche prices, default: all
% RMSE_method                   ... which definition of pricing error to use
% LGD_method                    ... method for (joint) distribution of LGDs
% how_port_loss                 ... how to calculate the portfolio loss distribution
%                                   1 ... load from external file
%                                   2 ... calculate
%                                   3 ... calculate and save in external file
% method5                       ... which definition to use for the 5th parameters
%                                   'mu' = expected jump size \mu (default)
%                                   'mu*L' = jump intensity x jump size
% method2                       ... which definition to use for the 2nd parameter
%                               ... 'thet' = theta_total
%                               ... 'thet*k' = theta_total * k
% CDX2                          ... second CDX structure for robust RMSE calculation (optional)
% --------------------------------------------------------------------------------------------------
% sample call: wrapper_tranche_mispricing_xi(0.5, 1, CDX_NA_IG2_monthly, discounts_IMM, datenum('02/01/2006'), datenum('03/01/2006'), 2000, [1 0 0 0], [1 0 0])
% --------------------------------------------------------------------------------------------------

if (nargin <= 14)
    CDX2 = [];
end

% Determine date-range that is updated
%CDX = normalize_ai(CDX);
start_pos = find(CDX.dates{1} >= start_date_num, 1, 'first');
end_pos = find(CDX.dates{1} <= end_date_num, 1, 'last');
used_dates = CDX.dates{1}(start_pos:end_pos);

% Set new parameters
x0 = get_x0(CDX, used_dates, method5, method2);
disp(['xi:' num2str(xi')])
x0{i} = xi; 

% Update model-implied prices and calculate RMSE pricing error
[rmse, cdx_new] = wrapper_tranche_mispricing(x0, CDX, discounts_IMM, start_date_num, end_date_num, N, ...
                                             maturities_cds, maturities_tranches, RMSE_method, LGD_method, how_port_loss, method5, method2, CDX2);

% Extract time series of pricing errors
rms_errors = cdx_new.rmse(start_pos:end_pos);
%rms_5yr_cds = cdx_new.rmse_5yr_cds(start_pos:end_pos);
%rms_cds = cdx_new.rmse_avg_cds(start_pos:end_pos);

